////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) since 1999. VASCO DATA SECURITY
// All rights reserved. http://www.vasco.com
//
////////////////////////////////////////////////////////////////////////////////

#import <Foundation/Foundation.h>
NS_ASSUME_NONNULL_BEGIN

/**
 * <p>An {@link CDDCParams} object provides parameters for CDDC process.</p>
 *
 */
NS_REFINED_FOR_SWIFT
@interface CDDCParams : NSObject

/**
 * Gets the current CDDC refresh delay in seconds.
 * @return current refresh delay (in seconds), default value is 60
 */
- (long)refreshDurationSeconds;

/**
 * Sets the refresh delay for the automatic CDDC data collection.
 * If the delay was not set manually, default value is 60 seconds.
 * @param duration new refresh delay (in seconds)
 * @param error a NSError raised if there is an error during the process.
 * @return true if the call is successful, If an error occurred the reason will be put in the error.
 */
- (BOOL)setRefreshDurationSeconds:(long)duration error:(NSError **)error;

/**
 * List of all optional fields requiring user permissions
 */
NS_REFINED_FOR_SWIFT
typedef enum {
    /** Retrieve Bluetooth information */
    OptionalRetrievableFieldsBluetooth = 0,
    
    /** Retrieve geolocation information */
    OptionalRetrievableFieldsGeolocation
} OptionalRetrievableFields;


/**
 * Gets the current list of fields for automatic retrieval that require permissions.
 * @return list of configured fields
 */
- (NSSet<NSNumber *> *)optionalRetrievableFields;

/**
 * Add a field to the list of fields to be automatically retrieved and that require permissions.
 * @param field new field to add
 * @param error a NSError raised if there is an error during the process.
 * @return true if the call is successful, If an error occurred the reason will be put in the error.
 */
- (BOOL)addOptionalRetrievableField:(OptionalRetrievableFields)field error:(NSError **)error;

/**
 * Sets the list of fields to be automatically retrieved and that require permissions.
 * @param optionalRetrievableFields new field list
 * @param error a NSError raised if there is an error during the process.
 * @return true if the call is successful, If an error occurred the reason will be put in the error.
 */
- (BOOL)setOptionalRetrievableFields:(NSSet<NSNumber *> *)optionalRetrievableFields error:(NSError **)error;

@end

NS_ASSUME_NONNULL_END
